unit Trustee;

interface

uses
    WinTypes,
    WinProcs,
    Classes,
    Graphics,
    Forms,
    Controls,
    Buttons,
    StdCtrls,
    ExtCtrls,
    NWTools,
    NwProp,
    Nwlib,
    NWServer;

type
  TwinTrustee = class(TForm)
    bSave: TBitBtn;
    bCancel: TBitBtn;
    Bevel1: TBevel;
    serverName: TEdit;
    volName: TEdit;
    pathName: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    rightsBox: TGroupBox;
    lRead: TCheckBox;
    lWrite: TCheckBox;
    lCreate: TCheckBox;
    lModify: TCheckBox;
    lFileScan: TCheckBox;
    lAccessControl: TCheckBox;
    lErase: TCheckBox;
    lSupervisor: TCheckBox;
    procedure bSaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    execute,
    creating   : boolean ;
    oldServer,
    oldVolName,
    oldPath,
    cUserID,
    cPath      : string ;
    nServer    : TNWConnHandle ;
  end;

var
  winTrustee: TwinTrustee;

implementation

{$R *.DFM}

procedure TwinTrustee.FormCreate(Sender: TObject);
  begin
    creating := false ;
    execute  := false ;
  end;

procedure TwinTrustee.bSaveClick(Sender: TObject);
  var
    rightsList : TNWRights ;
  begin
    with rightsList do begin
      supervisor    := ( lSupervisor.checked ) ;
      read          := ( lRead.checked )       ;
      open          := ( false )               ; {needed only for netware 2.x support}
      write         := ( lWrite.checked )      ;
      create        := ( lCreate.checked )     ;
      erase         := ( lErase.checked )      ;
      modify        := ( lModify.checked )     ;
      filescan      := ( lFilescan.checked )   ;
      accessControl := ( lAccessControl.checked ) ;
    end;
    {remove old trustee if editing}
    if (not creating) then
      deleteTrusteeRight(getServerHandle(oldServer),
                         cUserID,
                         oldVolName,
                         oldPath) ;
    {create trustee}
    execute :=  modifyTrusteeRights(nServer,
                                    cUserID,
                                    volName.text,
                                    pathName.text,
                                    rightsList);
  end;


end.
